//[VSCRIPT] Naptha
// written by Alien31, with some help from TF2Maps

::PlayerCache <- MaxClients().tointeger()
::GlobalIgnite <- SpawnEntityFromTable("trigger_ignite", { spawnflags = 1, burn_duration = 10, damage_percent_per_second = 0})

//GENERAL SETTINGS
//----------------
const OilDuration = 5
const OilDrip_MDL = "models/props_Naphtha/player_oil_drips.mdl"
const OilColor = 0x001B49
PrecacheModel(OilDrip_MDL)
//----------------

function MapThink()
{
  for(local i = 1; i <= PlayerCache;i++)
  {
    local player = PlayerInstanceFromIndex(i)
    
    if(!player || !player.IsAlive() || player.GetTeam() && 2 == 0)
      continue
	  
    local playerscope = player.GetScriptScope()
    
	//Keep them oiled if inside a puddle
	if (!playerscope.isInsidePuddle)
	{
		if(playerscope.isOilCovered && Time() >= playerscope.Timer_Oil)
		{
			Oil_Remove(player)
		}
	}
	else
	{
		playerscope.Timer_Oil = Time() + OilDuration
	}
  }
  return -1
}
AddThinkToEnt(self, "MapThink");

::Oil_Apply <- function()
{
	local victimscope = self.GetScriptScope()

	if (!victimscope.isOilCovered)	
	{
		victimscope.isOilCovered <- true
		victimscope.Timer_Oil = Time() + OilDuration
		self.SetScriptOverlayMaterial("effects/oil_overlay")
		//self.AddCondEx(Constants.ETFCond.TF_COND_STUNNED, OilDuration, null)
		self.AddCondEx(Constants.ETFCond.TF_COND_BURNING_PYRO , OilDuration, null) 
		
		//This is what happends when i get 0 help...
		//Unfreeze this whenever we get material functions... VALVe
		/*
		SetPropInt(self, "m_clrRender", OilColor);
		for (local wearable = self.FirstMoveChild(); wearable != null; wearable = wearable.NextMovePeer())
			SetPropInt(wearable, "m_clrRender", OilColor);
		*/

		local Oildripping = SpawnEntityFromTable("tf_wearable", {
		targetname = "paint_drips_" + self.entindex()
		});
		Oildripping.SetModel(OilDrip_MDL);
		Oildripping.SetAbsOrigin(self.GetOrigin());
		NetProps.SetPropBool(Oildripping, "m_bForcePurgeFixedupStrings", true);
		NetProps.SetPropEntity(Oildripping, "m_hOwnerEntity", self);
		EntFireByHandle(Oildripping, "SetParent", "!activator", 0, self, self);	
	}

}
::Oil_Remove <- function(player)
{
	player.GetScriptScope().isOilCovered <- false
	player.SetScriptOverlayMaterial("")
	GlobalIgnite.AcceptInput("EndTouch", "", null, player)
	//player.RemoveCond(Constants.ETFCond.TF_COND_STUNNED)
	
	//Unfreeze this whenever we get material functions... VALVe
	/*
    SetPropInt(player, "m_clrRender", 0xFFFFFF);
	for (local wearable = player.FirstMoveChild(); wearable != null; wearable = wearable.NextMovePeer())
        SetPropInt(wearable, "m_clrRender", 0xFFFFFF);
	*/
	DoEntFire("paint_drips_" + player.entindex(), "Kill", "", -1, null, null);
}

::Oil_InsidePuddle <- function()
{
	self.GetScriptScope().isInsidePuddle <- true
}
::Oil_OutsidePuddle <- function()
{
	self.GetScriptScope().isInsidePuddle <- false
}


if (!("MapEvents_Naphtha" in getroottable()))
	::MapEvents_Naphtha <- {};
::MapEvents_Naphtha.clear();
::MapEvents_Naphtha =
{
	OnGameEvent_player_spawn = function(params)
	{
		local player = GetPlayerFromUserID(params.userid)
	
		player.ValidateScriptScope()
		player.GetScriptScope().isOilCovered <- false
		player.GetScriptScope().isInsidePuddle <- true
		player.GetScriptScope().Timer_Oil <- 0
		Oil_Remove(player)	
	}
	
	OnGameEvent_player_death = function(params)
	{
		local player = GetPlayerFromUserID(params.userid)
		
		//So he is not permanently blind
		if ( player.GetScriptScope().isOilCovered)
			Oil_Remove(player)
	}
	
	OnScriptHook_OnTakeDamage = function(params)
	{
		local victim = params.const_entity;
		local inflictor = params.inflictor;
		local dmgtype = params.damage_type

		// Burn like a bbq bacon burger
		if ( victim.IsPlayer() ) 
		{
			if ( victim.GetScriptScope().isOilCovered && dmgtype & ( 2 | 8 | 64 | 16777216) ) {
				GlobalIgnite.AcceptInput("StartTouch", "", null, victim)
				Oil_Remove(victim)				
			}	
		}
	}
}
__CollectGameEventCallbacks(MapEvents_Naphtha)